/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.saml;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.searchguard.enterprise.auth.saml.SamlAuthenticator;
import com.floragunn.searchsupport.PrivilegedCode;
import java.net.URI;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;

public class SamlHTTPMetadataResolver
extends HTTPMetadataResolver {
    private static int componentIdCounter = 0;
    private volatile ResolverException lastRefreshException;

    public SamlHTTPMetadataResolver(URI metadataUrl, TLSConfig tlsConfig) throws ResolverException {
        super(SamlHTTPMetadataResolver.createHttpClient(tlsConfig), metadataUrl.toString());
        this.setId(SamlAuthenticator.class.getName() + "_" + ++componentIdCounter);
        this.setRequireValidMetadata(true);
        this.setFailFastInitialization(false);
        BasicParserPool basicParserPool = new BasicParserPool();
        try {
            basicParserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException(e);
        }
        this.setParserPool((ParserPool)basicParserPool);
    }

    protected byte[] fetchMetadata() throws ResolverException {
        return (byte[])PrivilegedCode.execute(() -> {
            byte[] result = SamlHTTPMetadataResolver.super.fetchMetadata();
            this.lastRefreshException = null;
            return result;
        }, ResolverException.class);
    }

    public void initializePrivileged() throws ComponentInitializationException {
        PrivilegedCode.execute(() -> this.initialize(), ComponentInitializationException.class);
    }

    private static HttpClient createHttpClient(TLSConfig tlsConfig) {
        return (HttpClient)PrivilegedCode.execute(() -> {
            HttpClientBuilder builder = HttpClients.custom();
            builder.useSystemProperties();
            if (tlsConfig != null) {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)tlsConfig.toSSLConnectionSocketFactory());
            }
            return builder.build();
        });
    }

    public ResolverException getLastRefreshException() {
        return this.lastRefreshException;
    }
}

